/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server_bound;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.entity.TileEntityRedCtrl;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.net.Packet;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector3i;

public class C2SMessageRedstoneCtrl
extends Packet
implements Runnable {
    private Player player;
    private Vector3i pos;
    private String risingEdgeURL;
    private String fallingEdgeURL;

    public C2SMessageRedstoneCtrl() {
    }

    public C2SMessageRedstoneCtrl(Vector3i p, String r, String f) {
        this.pos = p;
        this.risingEdgeURL = r;
        this.fallingEdgeURL = f;
    }

    public C2SMessageRedstoneCtrl(FriendlyByteBuf buf) {
        super(buf);
        this.pos = new Vector3i((ByteBuf)buf);
        this.risingEdgeURL = buf.m_130277_();
        this.fallingEdgeURL = buf.m_130277_();
    }

    @Override
    public void run() {
        Level world = this.player.f_19853_;
        BlockPos blockPos = this.pos.toBlock();
        double maxRange = this.player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        if (this.player.m_20275_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()) > maxRange * maxRange) {
            return;
        }
        BlockEntity te = world.m_7702_(blockPos);
        if (te == null || !(te instanceof TileEntityRedCtrl)) {
            return;
        }
        TileEntityRedCtrl redCtrl = (TileEntityRedCtrl)te;
        if (!redCtrl.isScreenChunkLoaded()) {
            Util.toast(this.player, "chunkUnloaded", new Object[0]);
            return;
        }
        TileEntityScreen tes = redCtrl.getConnectedScreen();
        if (tes == null) {
            return;
        }
        if ((tes.getScreen(redCtrl.getScreenSide()).rightsFor(this.player) & 1) == 0) {
            return;
        }
        redCtrl.setURLs(this.risingEdgeURL, this.fallingEdgeURL);
    }

    @Override
    public void m_5779_(FriendlyByteBuf buf) {
        this.pos.writeTo((ByteBuf)buf);
        buf.m_130070_(this.risingEdgeURL);
        buf.m_130070_(this.fallingEdgeURL);
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (this.checkServer(ctx)) {
            this.player = ctx.getSender();
            ctx.enqueueWork((Runnable)this);
            ctx.setPacketHandled(true);
        }
    }
}

